Images.actionIcon = LoadImage("Action-icon.png");
Images.supportIcon = LoadImage("Support-icon.png");
Images.commandIcon = LoadImage("Command-icon.png");
Images.profIcon = LoadImage("Proficiency-icon.png");

function Ability(name, mp, ap, type, description)
{
	this.name = name;
	this.mp = mp;
	this.ap = ap;
	this.currentap = 0;
	this.type = type;
	switch (type)
	{
		case "Action":
			this.icon = Images.actionIcon;
			break;
		case "Support":
			this.icon = Images.supportIcon;
			break;
		case "Command":
			this.icon = Images.commandIcon;
			break;
		case "Proficiency":
			this.icon = Images.profIcon;
			break;
		default:
			QuitMessage("Invalid Ability type. Available types are: \"Action\", \"Support\", \"Command\", and \"Proficiency\"");
			break;
	}
	this.description = description;
}

Ability.prototype.clone = function()
{
	var tAbility = new Ability(this.name, this.mp, this.ap, this.type, this.description);
	return tAbility;
}

// Here are ALL of the abilities in the game
var Abilities = new Object();
// Action Abilities
Abilities.Fire = new Ability("Fire", 6, 25, "Action", "Fire-element attack on single/multiple target(s)");
Abilities.Ice = new Ability("Ice", 6, 25, "Action", "Ice-element attack on single/multiple target(s)");
Abilities.Bolt = new Ability("Bolt", 6, 25, "Action", "Lightning-element attack on single/multiple target(s)");
Abilities.Cure = new Ability("Cure", 6, 25, "Action", "Restores HP to single/multiple target(s)");
// Support Abilities
Abilities.HPp10 = new Ability("HP+10%", 0, 40, "Support", "Increases maximum HP by 10%");
// Command Abilities

// Proficiency Abilities

function Idolix(name, description)
{
	this.name = name;
	this.description = description;
	this.ability = new Array();
	this.lv = 1;
}

Idolix.prototype.clone = function()
{

}

Idolix.prototype.addAbility = function(ability, lv)
{
	this.ability[this.ability.length] = ability.clone();
	this.ability[this.ability.length - 1].lv = lv;
}

Idolix.prototype.giveAP = function(ap)
{
	for (var i = 0; i < this.ability.length; i ++)
	{
		if (this.lv >= this.ability[i].lv)
		{
			this.ability[i].currentap += ap;
			if (this.ability[i].currentap >= this.ability[i].ap)
			{
				this.ability[i].currentap = this.ability[i].ap;
			}
		}
	}
}

var Idolixes = new Object();
Idolixes.Phrite = new Idolix("Phrite", "Some funny evil guy");
Idolixes.Phrite.addAbility(Abilities.Fire, 1);
Idolixes.Phrite.addAbility(Abilities.Ice, 1);
Idolixes.Phrite.addAbility(Abilities.Bolt, 2);

// This create all those super-spiffy commands
function Command(name, touse, effect, abilNum)
{
	this.name = name;
	this.touse = touse;
	if (abilNum != undefined)
	{
		this.ability = new Array(abilNum);
	}
	this.enabled = true;
	this.link = PrepareAction;
	this.effect = effect;
}

Command.prototype.addAbility = function(ability, position)
{
	this.ability[position] = ability.clone();
	this.ability[position].learned = false;
}

function GetCommand()
{
	return Game.party[Game.curBattle.current].bMenu.items[Game.party[Game.curBattle.current].bMenu.selection];
}

function GetUser()
{
	return Game.party[Game.curBattle.current];
}

// Here are the commands I know you've wanted to look at
var Commands = new Object();
Commands.TBlackMag = new Command("Black Mag", true, undefined);
Commands.TAttack = new Command("Attack", true, NormalAttack);
Commands.TItem = new Command("Item", true);
Commands.Defend = new Command("Defend", true);
Commands.TSkill = new Command("Skill", true);
Commands.TMess = new Command("Mess", true);

function PrepareAction()
{
	var command = GetCommand();
	var user = GetUser();
	var target = user.getTarget();
	command.effect(user, target);
	EndTurn(user);
}

function NormalAttack(user, target)
{
	GiveDamage(target, GetAttack(user));
}